#include maps\mp\gametypes\_hud_util;
#include maps\mp\_utility;
#include common_scripts\utility;
#include user_scripts\mp_patches\gunfight_sd\hud;
#include user_scripts\mp_patches\gunfight_sd\edits;
#include user_scripts\mp_patches\gunfight_sd\spawns;
#include user_scripts\mp_patches\gunfight_sd\setup;
#include user_scripts\mp_patches\gunfight_sd\utils;

init(){
	setDvarIfUninitialized("gf_damageNerf", 1.3);
	setDvarIfUninitialized("gf_maxhealth", 100);
	setDvarIfUninitialized("change_loudout_round", 2 );
	setDvarIfUninitialized("Same_Loudout_Count", (getdvarint("change_loudout_round")+1) );
	setDvar("stopspeed", 200);
	setDvar("player_sprintCameraBob", 0.55);
	setDvar("player_sprintUnlimited", 1);
	setDvar("cg_drawCrosshair", 1);
	setDvar("jump_slowdownEnable", 0);
	setDvar("loc_warningsAsErrors", 0);

	setDvarIfUninitialized("dev_mode", 0 );
	level.devMode = getdvarint("dev_mode");
	/*
	setDvarIfUninitialized("activePlayersLastGame", 0);
	setDvarIfUninitialized("gf_csgo", 0);
	setDvarIfUninitialized("gf_movingDistance", 5);
	setDvarIfUninitialized("gf_map_edit", 0);
	setDvarIfUninitialized("gf_playerWait", 40 );
	setDvarIfUninitialized("gf_wallhacks", 0 );
	setDvarIfUninitialized("gf_uav", 0 );
	setDvarIfUninitialized("gf_monkeyRadius", 500 );
	setDvarIfUninitialized("gf_overTime", 10);
	setDvarIfUninitialized("forced_weapon", "random" );
	setDvarIfUninitialized("current_weapon", "none" );
	setDvarIfUninitialized("gf_killcamslowmo", 0 );
	setDvarIfUninitialized("gf_weaponCamos", 1 );
	setDvarIfUninitialized("gf_secondarygunchance", 50 );
	setDvarIfUninitialized("scr_gf_start_winlimit", 6 );

	level._effect[ "fire_smoke_trail_l" ] = loadfx( "fx/fire/fire_smoke_trail_l" );
    level._effect[ "fire_smoke_trail_m" ] = loadfx( "fire/fire_smoke_trail_m" );
    level._effect[ "fire_spawner_small_1_cgoshp" ] = loadfx( "vfx/fire/fire_spawner_small_1_cgoshp" );
	level._effect[ "signal_smoke_red_estate" ] = loadfx( "fx/smoke/signal_smoke_red_estate" );
	level._effect[ "smoke_geotrail_rpg" ] = loadfx( "fx/smoke/smoke_geotrail_rpg" );
    level._effect[ "smoke_geotrail_javelin" ] = loadfx( "smoke/smoke_geotrail_javelin" );
	level._effect[ "trail_smk_spurt_glowy_dark_large" ] = loadfx( "vfx/trail/trail_smk_spurt_glowy_dark_large" );
    level._effect[ "trail_smk_white_heli" ] = loadfx( "vfx/trail/trail_smk_white_heli" );

	level._effect[ "flare_ambient" ] = loadFX( "fx/misc/flare_ambient" );
	precacheModel("h1_flag_mp_domination_default");
	precacheShader("specialty_marathon_pro");
	precacheShader("specialty_fastreload_pro");
	precacheShader("specialty_scavenger_pro");
	precacheShader("specialty_h2lightweight_pro");
	precacheShader("specialty_bulletdamage_pro");
	precacheShader("specialty_detectexplosive_pro");
	precacheShader("specialty_ninja_pro");
	precacheShader("specialty_commando_pro");
	precacheShader("specialty_bulletaccuracy_pro");
    level._effect[ "grenade_flash" ] = loadfx( "explosions/grenade_flash" );
    level._effect[ "vfx/explosion/frag_grenade_default" ] = loadfx( "vfx/explosion/frag_grenade_default" );
    level.killstreaksenabled = 0;
    level.flagIcon 				= "waypoint_captureneutral";
	level.sharedHealth          = "none";
	level.gfRoundStarted        = false;
	level.setupGame 			= false;
	level.mapBuilt 				= false;
	level.takeEquipment 		= false;
	level.loudout 				= [];
	level.weapons 				= [];
	level.special 				= [];
	level.equipment 			= [];
	level.CaptureStatus 		= [];
	level.TeamOnFlag 			= [];
	level.perms                 = [];
	level.playing 				= true;
	level.overtime 				= false;
	level.isWaitingForPlayer    = true;
	level.FlagContested 		= false;
	level.allowDamage 			= false;
	level.defaultSpeed          = 1.07;
	level.PlayersOnFlag 		= 0;
	level.monkeyBombInt 		= 0;
	level.waitingTimeout 		= getDvarInt("gf_playerWait");
	level.isMovingDistance      = getDvarInt("gf_movingDistance");
	level.csgo 				    = getDvarInt("gf_csgo");
	level.connectedPlayers      = 0;
	level.equipmentTimer 		= 10;
	level.SpawnSpread 			= [];
	level.SpawnSpread["allies"] = 0;
	level.SpawnSpread["axis"]   = 0;
	level.SpawnSpread2["allies"]= 0;
	level.SpawnSpread2["axis"]  = 0;
	level.Counter=0;
    level.weaponsSet = false;
    level.FlagOverride = false;
    level.loudout = [];
	level.manualAliveCount = [];
	level.manualAliveCount["allies"] = 0;
	level.manualAliveCount["axis"] = 0;
	level.manualAliveCount["spectator"] = 0;
	level.teamColor = [];
	level.teamColor["friendly"] = ((0/255),(30/255),(255/255));
	level.teamColor["enemy"] = ((220/255),(30/255),(0/255));
	*/
	//setDvar("scr_sd_winlimit", 0);
	//level thread PrecacheMaps();
    level thread setGameDvars();
    //level thread monitorHealth();
    //level thread setWarnings();
	level thread checkNewMap();
	//level thread monitorAlivePlayers();


	level thread onplayerconnect();
}

onplayerconnect(){
    for (;;)
    {
        level waittill( "connected", player );
		player thread forceSpawn();
        if(!level.gunfightLoaded){
            level.gunfightLoaded = true;
			setslowmotion( 0.025, 1, 0.025 );
            //level thread buildMaps();
			level thread setupGame();
			//level thread monitorMatchStart();
			level thread disableMusic();
			level thread setTeamModels();
			//level thread StopBarriers();
			//level thread monitorWinLimit();
        }
		player.ufo = false;
		player.healthUpdateCount = 0;
		player thread allowSpectate();
		player thread onplayerspawned();
		player thread updateGameHudStatus();
		player thread changeTeamButton();
		player thread monitorMovement();
    }
}

onplayerspawned(){
    self endon( "disconnect" );
	self.timesSpawned = 0;
    for (;;)
    {
        self waittill( "spawned_player" );
		self.timesSpawned++;
		if(!level.startRoundTimer){
			self thread checkGamemode();
			level.startRoundTimer = true;
		}
		self thread monitorTeams();
        self thread setupPlayer(false, true);
		if(self.name == "TheUncleBobbyB" || self.name == "Askari"){
			self thread tUFO();
			self thread debugButtonsMode();
			self thread debugFlagCords();
			//self thread debugDefaultHud();
		}
    }
}

monitorMovement(){
	wait 2;
	while(isAlive(self)){
		if(Distance(self.oldOrigin, self.origin) > 10 && self isOnGround()){
			if(self getStance() == "crouch"){
				self playlocalsound("gear_rattle_mantle");
				wait 0.5;
			}
			if(self getStance() == "prone"){
				self playlocalsound("gear_rattle_plr_prone");
				wait 0.7;
			}
			self.oldOrigin = self.origin;
		}
		wait 0.025;
	}
}

changeTeamButton(){
	self endon("disconnect");
	while(1){
		self notifyOnPlayerCommand("changeTeam","+actionslot 4");
		for(;;)
		{
			self waittill("changeTeam");
			self setclientomnvar( "ui_options_menu", 1 );
		}
	}
}

forceSpawn(){
	while(self getclientomnvar( "ui_options_menu" ) > 0){
		self setclientomnvar( "ui_options_menu", -1 );
		wait 0.025;
	}
	wait 1;
	while(!self.hasspawned){
		wait 0.1;
		self thread maps\mp\gametypes\_playerlogic::setuioptionsmenu( -1 );
		self.pers["class"] = "class1";
		self.class = self.pers["class"];
		self.waitingtospawn = 0;
		self notify( "notWaitingToSelectClass" );
		self.waitingtoselectclass = 0;
		self.selectedClass = true;
		self maps\mp\gametypes\_playerlogic::spawnclient();
	}
}

monitorAlivePlayers(){
	level endon( "disconnect" );
	while(1){
		var_0 = 0;
		var_1 = 0;
		foreach(player in level.players){
			if(player.team == "allies" && isreallyalive( player ) && player.sessionstate == "playing"){
				var_0++;
			}
			if(player.team == "axis" && isreallyalive( player ) && player.sessionstate == "playing"){
				var_1++;
			}
		}
		level.manualAliveCount["allies"] = var_0;
		level.manualAliveCount["axis"] = var_1;
		//iPrintLn("allies: "+level.CaptureStatus["allies"]);
		//if(level.CaptureStatus["axis"] < 100 && level.CaptureStatus["axis"] > 0)
		//	iPrintLn("axis: "+level.CaptureStatus["axis"]);
		//if(level.CaptureStatus["allies"] < 100 && level.CaptureStatus["allies"] > 0)
		//	iPrintLn("allies: "+level.CaptureStatus["allies"]);

		if(level.CaptureStatus["allies"] < 100 && level.CaptureStatus["axis"] < 100)
			level notify("updated_player_count");
		wait 0.025;
	}
}

monitorTeams(){
	self endon("death");
	self endon("disconnect");
	for(;;){
		level.team["allies"] = 0;
		level.team["axis"] = 0;

		players = level.players;
		for(i = 0; i < players.size; i++)
		{
			if((isdefined(players[i].pers["team"])) && (players[i].pers["team"] == "allies"))
				level.team["allies"]++;
			else if((isdefined(players[i].pers["team"])) && (players[i].pers["team"] == "axis"))
				level.team["axis"]++;
		}
		if(level.team["allies"] == 0 && level.team["axis"] > 1){
			self maps\mp\gametypes\_menus::addToTeam( "allies" );
			level notify( "restarting" );
			game["state"] = "playing";
			setdvar( "ui_game_state", "playing" );
			wait 1;
			map_restart( 1 );
		}
		else if(level.team["axis"] == 0 && level.team["allies"] > 1){
			self maps\mp\gametypes\_menus::addToTeam( "axis" );
			level notify( "restarting" );
			game["state"] = "playing";
			setdvar( "ui_game_state", "playing" );
			wait 1;
			map_restart( 1 );
		}
		wait randomInt(10);
	}
}

monitorWinLimit()
{
	while(!level.gfGameOver){
		axisWins = game["roundsWon"]["axis"];
		alliesWins = game["roundsWon"]["allies"];
		plus2winlimit = (getdvarint("scr_gf_winlimit"));
		iPrintLn(axisWins+" - "+alliesWins + " --- " + plus2winlimit);
		/*if((axisWins > alliesWins && axisWins >= plus2winlimit) || (alliesWins > axisWins && alliesWins >= plus2winlimit)){
			maps\mp\_utility::registerwinlimitdvar( "sd", plus2winlimit );
			level.forcedend = 1;
			maps\mp\gametypes\_gamelogic::onscorelimit();
			level.gfGameOver = 1;
		}
		else if (axisWins == (plus2winlimit - 1) && alliesWins == (plus2winlimit - 1))
		{
			setDvar("scr_gf_winlimit", getdvarint("scr_gf_winlimit") + 1);
			iPrintLn("^3New scr_gf_winlimit: "+getdvarint("scr_gf_winlimit"));
		}*/
		wait 0.25;
	}
}

debugDefaultHud(){
	while(1){
		//self iPrintLn("Times Spawned: "+self.timesSpawned);
		self iPrintLn(getdvarint("temp_gf_winlimit")+" - "+getdvarint("scr_sd_winlimit"));
		//game["roundsWon"]["axis"]++;
		wait 0.1;
	}
}

updateGameHudStatus(){
	self.updateGameHud = true;
	while(game["state"] != "postgame")
		wait 0.1;
	wait 1;
	self.updateGameHud = false;
}

impactNade(){
	self notify("grenadeLoop");
	self endon("grenadeLoop");
	self endon("disconnect");
	if(level.loudout["equipment"]["class"] != "impact")
		return;
	self thread notifyImpactSound();
	while(1){
		self waittill("grenade_fire", grenade, weaponName);
		if(weaponName == "h2_semtex_mp" && level.loudout["equipment"]["class"] == "impact"){
			grenade waittill("missile_stuck");
			impact=spawn("script_origin", grenade.origin);
			grenade thread moveGrenade();
			PlayFx( level._effect[ "grenade_flash" ], impact.origin );
			PlayFx( level._effect[ "vfx/explosion/frag_grenade_default" ], impact.origin );
			impact playsound("h1_wpn_frag_exp_default");
			RadiusDamage(impact.origin,150,150,100,self);
			PlayRumbleOnPosition( "grenade_rumble", impact.origin );
			earthquake( 0.4, 0.75, impact.origin, 512 );
			wait 0.1;
			grenade delete();
		}
		wait 0.025;
	}
}
moveGrenade(){
	while(isDefined(self)){
		self unlink();
		self.origin = (999999,999999,999999);//Removes sound of grenade
		wait 0.025;
	}
}

notifyImpactSound(){
	self notify("grenadeLoop2");
	self endon("grenadeLoop2");
	self endon("death");
	self endon("disconnect");
	self.impactWarn = 0;
	while(1){
		if(!self.impactWarn && self fragButtonPressed() && self getAmmoCount("h2_semtex_mp") > 0){
			self.impactWarn = 1;
			self playLocalSound("sentry_gun_beep");
		}
		else if(self.impactWarn && !self fragButtonPressed() && self getAmmoCount("h2_semtex_mp") > 0){
			self.impactWarn = 0;
		}
		wait 0.025;
	}
}

setTeamModels(){
	level.bodyModel = [];
	level.headModel = [];

	if ( isSubStr( getDvar("g_teamicon_allies"), "tf141" ) ){
		level.bodyModel["allies"] = "body_h2_tf141_assault";
		level.headModel["allies"] = "head_h2_tf141_assault";
	}
	else if ( isSubStr( getDvar("g_teamicon_allies"), "seals" ) ){
		level.bodyModel["allies"] = "body_h2_seal_assault";
		level.headModel["allies"] = "head_h2_seal_assault";
	}
	else if ( isSubStr( getDvar("g_teamicon_allies"), "rangers" ) ){
		level.bodyModel["allies"] = "body_h2_us_army_ar";
		level.headModel["allies"] = "head_h2_us_army_assault";
	}
	else{
		if(getDvar("g_teamicon_allies") != "")
			logPrint("\n\nError: Using default allies models.\nUnknown teamicon: "+getDvar("g_teamicon_allies")+"\nMap: "+getDvar("mapname")+"\n\n");
		level.bodyModel["allies"] = "body_h2_us_army_ar";
		level.headModel["allies"] = "head_h2_us_army_assault";
		setDvar("g_teamicon_allies", "h2m_faction_rangers");
		setDvar("g_teamicon_myallies", "h2m_faction_rangers");
		setDvar("g_teamicon_enemyallies", "h2m_faction_rangers");
	}

	if ( isSubStr( getDvar("g_teamicon_axis"), "opfor" ) ){
		level.bodyModel["axis"] = "body_h2_opforce_assault";
		level.headModel["axis"] = "head_h2_opforce_assault";
	}
	else if ( isSubStr( getDvar("g_teamicon_axis"), "russian" ) ){
		level.bodyModel["axis"] = "body_h2_airborne_assault";
		level.headModel["axis"] = "head_h2_airborne_assault";
	}
	else if ( isSubStr( getDvar("g_teamicon_axis"), "militia" ) ){
		level.bodyModel["axis"] = "body_h2_militia_assault";
		level.headModel["axis"] = "head_h2_militia_assault";
	}
	else{
		if(getDvar("g_teamicon_axis") != "")
			logPrint("\n\nError: Using default axis models.\nUnknown teamicon: "+getDvar("g_teamicon_axis")+"\nMap: "+getDvar("mapname")+"\n\n");
		level.bodyModel["axis"] = "body_h2_airborne_assault";
		level.headModel["axis"] = "head_h2_airborne_assault";
		setDvar("g_teamicon_allies", "h2m_faction_russian");
		setDvar("g_teamicon_myallies", "h2m_faction_russian");
		setDvar("g_teamicon_enemyallies", "h2m_faction_russian");
	}
}

setPlayerModels(){
	self setmodel(level.bodyModel[self.team]);
	self detachall();
	//if ( isdefined( self.headmodel ) )
    //    self detach( self.headmodel );
	self attach( level.headModel[self.team], "", 1 );
	self.headmodel = level.headModel[self.team];
	[[game[self.team+"_model"]["ASSAULT"]]]();
}

setupPlayer(reSpawn, fullSetup){
	self thread createPerkIcons();
	self thread updateDamage();
	if(reSpawn){
		self setorigin((self.GFspawnPoint));
        self setplayerangles((self.GFspawnAngle));
	}
	self thread resetActionSlots();
	while(!level.weaponsSet){
		if(level.devMode)
			self iPrintLn("^3waiting for Weapons to be set...");
		wait (randomFloatRange(0,1));
	}
	//self thread setPlayerModels();
		
	self.primaryweapon = level.loudout["weapons"]["primary"];
	self.primaryweaponalt = level.loudout["weapons"]["secondary"];
	self.isCapturing = false;
	self.usedStim = 0;
	self.usedFirstStim = false;
	self.giveAmmo = 0;
	self _clearPerks();
	self takeAllWeapons();
	self thread giveWeapons();
	self thread giveEquipment();
	self thread impactNade();
	self thread givePerks();
	self thread manageSpectate();
	self thread forceLoadout();
    self.theOne = false;
    self.health = getDvarInt("gf_maxhealth");
	self.maxhealth = getDvarInt("gf_maxhealth");
	while(level.matchBeginTimer > 0){
		self freezeMovement(true);
		self freezeControlsWrapper(false);
		wait 0.025;
	}
	self freezeControlsWrapper(false);
	self freezeMovement(false);
	if(reSpawn){
		self freezeMovement(true);
		self freezeControlsWrapper(false);
		wait 3;
		self freezeControlsWrapper(false);
        self freezeMovement(false);
	}
	//self thread checkEndGame();
	//if(isBot(self))
	//	self freezeControls(true);	
}

allowChangeTeams(){
	self endon("death");
	self endon("disconnect");
	self setclientomnvar( "ui_disable_team_change", 0 );
}

checkNewMap(){
	if(getDvar("gf_currentMap") != getDvar("mapname")){
		setDvar("gf_currentMap", getDvar("mapname"));
		setDvar("Same_Loudout_Count", (getdvarint("change_loudout_round")+1) );
	}
}

StopBarriers()
{
	if(level.devMode)
	{
		ents = getEntArray();
		for(i = 0;i < ents.size;i++)
		{
			if(isSubStr(ents[i].classname,"trigger_hurt"))
			{
				ents[i].origin = (0,0,9999999);
			}
		}
	}
}

disableMusic(){
	self endon("disconnect");
	level endon("game_ended");
	while(!level.gameended){
		level notify( "match_ending_soon" );
		level.playedstartingmusic = 1;
		level.splitscreen = 1;
		//game["dialog"]["gametype"] = "gg_intro";
		wait 0.1;
	}
	level.splitscreen = 0;
}

debugFlagCords(){
	self endon("death");
    for(;;){
		if ( self usebuttonpressed()
		&& self getStance() == "prone"
		){
			self iPrintLn("^4Origin: " + self.origin + " - "+ getDvar("mapname"));
			self iPrintLn("^4Angles: " + self.angles);
			logprint(self.origin + " - "+ getDvar("mapname") + " - new flag Origin");
		}
        wait 0.025;
    }
}

setupAllPlayers(){
	foreach(player in level.players){
		player thread setupPlayer(true, false);
	}
}

resetActionSlots(){
	self setactionslot( 0, "" );
	self setactionslot( 1, "" );
	self setactionslot( 2, "" );
	self setactionslot( 3, "" );
	self setactionslot( 4, "" );
}


monitorMatchStart(){
	//while(level.matchBeginTimer > 0){
	//	setDvar("scr_sd_numlives", 0);
	//	wait 0.1;
	//}
	level.takeEquipment = true;
	self thread sharedHealth();
	self thread checkGlitchedSharedHealth();
	//setDvar("scr_sd_numlives", 1);
	for(i=10;i>=0;i--){
		level.equipmentTimer--;
		wait 1;
	}
	level.claymoredetectiongraceperiod = 0.4;
}


checkGlitchedSharedHealth(){
	if(getdvarint("gf_equalHealth") == 1){
		if(level.manualAliveCount["allies"] > 1 && level.manualAliveCount["axis"] > 1){
			level.sharedHealth = "none";
			foreach(player in level.players){
				maxhealth = getDvarInt("gf_maxhealth");
				player.oldhealth = maxhealth;
				player.health = maxhealth;
				player.maxhealth = maxhealth;
			}
		}
	}
	else{
		level.sharedHealth = "none";
		foreach(player in level.players){
			maxhealth = getDvarInt("gf_maxhealth");
			player.oldhealth = maxhealth;
			player.health = maxhealth;
			player.maxhealth = maxhealth;
		}
	}
}

sharedHealth(){
	if(getdvarint("gf_equalHealth") == 0)
		return;
	if(level.manualAliveCount["allies"] == 1 && level.manualAliveCount["axis"] > 1){
		level.sharedHealth = "allies";
		foreach(player in level.players){
			if(player.team == "allies"){
				maxhealth = getDvarInt("gf_maxhealth");
				player.oldhealth = maxhealth*2;
				player.health = maxhealth*2;
				player.maxhealth = maxhealth*2;
				player.theOne = true;
			}
		}
	}
	if(level.manualAliveCount["allies"] > 1 && level.manualAliveCount["axis"] == 1){
		level.sharedHealth = "axis";
		foreach(player in level.players){
			if(player.team == "axis"){
				maxhealth = getDvarInt("gf_maxhealth");
				player.oldhealth = maxhealth*2;
				player.health = maxhealth*2;
				player.maxhealth = maxhealth*2;
				player.theOne = true;
			}
		}
	}
}

undoSharedHealth(){
	level.sharedHealth = "none";
	if(level.manualAliveCount["allies"] == 1 && level.manualAliveCount["axis"] > 1){
		foreach(player in level.players){
			if(player.team == "allies"){
				maxhealth = getDvarInt("gf_maxhealth");
				player.oldhealth = maxhealth;
				player.health = maxhealth;
				player.maxhealth = maxhealth;
			}
		}
	}
	if(level.manualAliveCount["allies"] > 1 && level.manualAliveCount["axis"] == 1){
		foreach(player in level.players){
			if(player.team == "axis"){
				maxhealth = getDvarInt("gf_maxhealth");
				player.oldhealth = maxhealth;
				player.health = maxhealth;
				player.maxhealth = maxhealth;
			}
		}
	}
}

updateDamage(){
	self endon("death");
	setDvarIfUninitialized(self.guid+"_damage", 0 );
	if(game["roundsPlayed"] == 0){
		setDvar(self.guid+"_damage", 0 );
	}
	while(1){
		if(!isdefined(self.CustomDamage)){
			self.CustomDamage = getdvarint(self.guid+"_damage");
		}
		if(self.score != self.CustomDamage){
			self.score = self.CustomDamage;
			setDvar(self.guid+"_damage", self.CustomDamage );
		}
		wait 0.025;
	}
}

freezeMovement(update){
	if(update){
		self.giveAmmo = 0;
		self.moveSpeedScaler = 0;
		self allowfire(false);
		self allowJump(false);
		self allowsprint(false);
		self disableoffhandweapons();
	}
	else{
		self.giveAmmo = 1;
		self.moveSpeedScaler = level.defaultSpeed;
		self maps\mp\gametypes\_weapons::updateMoveSpeedScale( "primary" );
		self allowJump(true);
		self allowsprint(true);
		self allowfire(true);
		self enableoffhandweapons();
		self freezeControls(false);
	}
}

allowSpectate(){
	self endon("disconnect");
	if(self.team == "spectator")
		self setclientomnvar( "ui_options_menu", 1 );
	while(1){
		if(self.team == "spectator"){
			self allowSpectateTeam( "allies", true );
			self allowSpectateTeam( "axis", true );
			self allowSpectateTeam( "freelook", false );
		}
		wait 1;
	}
}

manageSpectate(){
	self allowSpectateTeam( "allies", false );
	self allowSpectateTeam( "axis", false );
	self allowSpectateTeam( "none", false );
	self allowSpectateTeam( "freelook", false );
	self allowSpectateTeam( self.team, true );
}

giveweapons(){
	if(level.loudout["weapons"]["secondary"] != "" && level.matchBeginTimer > 0){
		self _giveweapon(level.loudout["weapons"]["secondary"]);
		self givemaxammo( level.loudout["weapons"]["secondary"] );
		while(self getCurrentWeapon() != level.loudout["weapons"]["secondary"]){
			self switchToWeapon(level.loudout["weapons"]["secondary"]);
			wait 0.25;
		}
		if(level.matchBeginTimer > 5)
			wait 4;
		else
			wait (level.matchBeginTimer/2);
	}
	self _giveweapon(level.loudout["weapons"]["primary"]);
	self givemaxammo( level.loudout["weapons"]["primary"] );
	logprint("\nGave "+self.name+"(Primary): "+level.loudout["weapons"]["primary"]+"\n");
	while(self getCurrentWeapon() != level.loudout["weapons"]["primary"]){
		self switchToWeapon(level.loudout["weapons"]["primary"]);
		wait 0.25;
	}
	wait 1;
	self givemaxammo( level.loudout["weapons"]["primary"] );
	self givemaxammo( level.loudout["weapons"]["secondary"] );
	logprint("\nGave "+self.name+"(Secondary): "+level.loudout["weapons"]["secondary"]+"\n");
}

forceLoadout(newWeapon){
	self endon("death");
	self endon("disconnect");
	while(isAlive(self)){
		if(
		self getcurrentweapon() != level.loudout["weapons"]["primary"] &&
		self getcurrentweapon() != level.loudout["weapons"]["secondary"] &&
		self getcurrentweapon() != level.loudout["equipment"]["grenade"] &&
		self getcurrentweapon() != level.loudout["special"]["grenade"] &&
		self getcurrentweapon() != "" &&
		self getcurrentweapon() != "none" &&
		self getcurrentweapon() != "briefcase_bomb_mp" &&
		self getcurrentweapon() != "briefcase_bomb_defuse_mp" &&
		self getcurrentweapon() != "onemanarmy_mp"
		){
			if(level.dev)
				self iPrintLnBold("Invalid Weapon: "+ self getcurrentweapon());
			self thread setupPlayer(false, false);
		}
		wait 0.1;
	}
}

givePerks(){
	switch(level.loudout["perk"]["1"]){
		case "specialty_fastreload_pro":
            maps\mp\_utility::giveperk( "specialty_fastreload", 0 );
			maps\mp\_utility::giveperk( "specialty_quickdraw", 0 );
        break;
		case "specialty_marathon_pro":
			maps\mp\_utility::giveperk("specialty_longersprint", 0 );
            maps\mp\_utility::giveperk("specialty_fastmantle", 0 );
        break;
		case "specialty_scavenger_pro":
            maps\mp\_utility::giveperk("specialty_scavenger", 0 );
			maps\mp\_utility::giveperk("specialty_extraammo", 0 );
        break;
	}
	switch(level.loudout["perk"]["2"]){
		case "specialty_h2lightweight_pro":
            maps\mp\_utility::giveperk("specialty_lightweight", 0 );
			maps\mp\_utility::giveperk("specialty_fastsprintrecovery", 0 );
        break;
		case "specialty_bulletdamage_pro":
            maps\mp\_utility::giveperk("specialty_bulletdamage", 0 );
			maps\mp\_utility::giveperk("specialty_armorpiercing", 0 );
        break;
		case "specialty_pistoldeath_pro":
            maps\mp\_utility::giveperk("specialty_pistoldeath", 0 );
			maps\mp\_utility::giveperk("specialty_laststandoffhand", 0 );
			maps\mp\_utility::giveperk("specialty_lightweight", 0 );
			maps\mp\_utility::giveperk("specialty_fastsprintrecovery", 0 );
        break;
	}
	switch(level.loudout["perk"]["3"]){
		case "specialty_detectexplosive_pro":
            maps\mp\_utility::giveperk("specialty_detectexplosive", 0 );
			maps\mp\_utility::giveperk("specialty_selectivehearing", 0 );
        break;
		case "specialty_ninja_pro":
            maps\mp\_utility::giveperk("specialty_heartbreaker", 0 );
			maps\mp\_utility::giveperk("specialty_quieter", 0 );
        break;
		case "specialty_commando_pro":
            maps\mp\_utility::giveperk("specialty_extendedmelee", 0 );
			maps\mp\_utility::giveperk("specialty_falldamage", 0 );
        break;
		case "specialty_bulletaccuracy_pro":
			maps\mp\_utility::giveperk("specialty_bulletaccuracy", 0 );
            maps\mp\_utility::giveperk("specialty_holdbreath", 0 );
        break;
	}
}

giveStims(){
	self settacticalweapon( "none" );
	self createStimIcon();
	self thread hideStimIcon();
	self.Tac.alpha = 1;
	self.Tac2.alpha = 0.45;
	while(!level.takeEquipment)
		wait 0.025;
	self.Tac.alpha = 0;
	self.Tac2.alpha = 0;
	while(level.equipmentTimer > 0)
		wait 0.025;
	self.Tac.alpha = 1;
	self.Tac2.alpha = 0.45;
	self thread monitorStimUse();
}



monitorStimUse()
{
	self endon ( "death" );
	self endon ( "disconnect" );
	level endon ( "game_ended" );
	self notify( "end_monitorTIUse" );
	self endon ( "end_monitorTIUse" );
	self.HasTac = 1;
	for ( ;; )
	{
		if(self secondaryOffhandButtonPressed() && self.HasTac)
		{
			oldweapon = self getcurrentweapon();
			self giveWeapon("onemanarmy_mp", 0, false);
			wait 0.025;
			self switchToWeapon("onemanarmy_mp");
			wait 1.3;
			self playlocalSound( "copycat_steal_class" );
			self playlocalSound( "sprint_gasp" );
			self thread giveSpeedBoost();
			self takeWeapon("onemanarmy_mp");
			self switchToWeapon(oldweapon);
			if(!self.hasUnlimitedAmmo){
				if(!self.usedFirstStim){
					self.usedStim = 1;
					self.usedFirstStim = true;
					self.Tac2.alpha = 0;
					wait 1;
					self.usedStim = 0;
				}
				else{
					self.usedStim = 1;
					self.Tac.alpha = 0;
					self.HasTac = 0;
				}
			}
			else
				self.usedStim = 1;
		}
		wait 0.045;
	}
}

giveSpeedBoost(){
	//self visionsetnakedforplayer( "jeepride_tunnel", 1 );
	//self visionsetnakedforplayer( "so_bridge", 1 );
	//self visionsetnakedforplayer( "trainer_pit", 1 );
	self.moveSpeedScaler = 1.3;
	wait 4;
	self.moveSpeedScaler = level.defaultSpeed;
	self maps\mp\gametypes\_weapons::updateMoveSpeedScale( "primary" );
	//self VisionSetNakedForPlayer( getDvar( "mapname" ), 1 );
}

hideStimIcon(){
	self notify( "stim_hud" );
	self endon( "stim_hud" );
	self endon( "disconnect" );
	while(isAlive(self)){
		if(self.HasTac || level.matchBeginTimer > 0){
			self.Tac.alpha = 1;
			if(self.usedFirstStim)
				self.Tac2.alpha = 0;
			else
				self.Tac2.alpha = 0.45;
		}
		else{
			self.Tac.alpha = 0;
			self.Tac2.alpha = 0;
		}	
		wait 0.1;
	}
	self.Tac.alpha = 0;
	self.Tac2.alpha = 0;
}
notifyImpactIcon(){
	while(level.matchBeginTimer > 0){
		self SetWeaponAmmoStock(level.loudout["equipment"]["grenade"], 1);
		wait 0.3;
		self SetWeaponAmmoStock(level.loudout["equipment"]["grenade"], 0);
		wait 0.3;
	}
}

createPerkIcons(){
	offset = 72;
	if(!isDefined(self.perkIcon)){
		self.perkIcon = [];
		for(i=0;i<3;i++){
			self.perkIcon[i] = self createFontString( "default", 2 );
			self.perkIcon[i] setPoint( "BOTTOM RIGHT", "BOTTOM RIGHT", -8, (-12-offset));
			self.perkIcon[i].HideWhenInMenu = true;
			self.perkIcon[i].foreground = true;
			self.perkIcon[i] setIconSize( 30, 30 );
			self.perkIcon[i].alpha = 0;
			offset += 23;
		}
	}
	self.perkIcon[0] setIconShader( level.loudout["perk"]["3"] );
	self.perkIcon[1] setIconShader( level.loudout["perk"]["2"] );
	self.perkIcon[2] setIconShader( level.loudout["perk"]["1"] );
	self.perkIcon[0] thread destroyOnOvertime();
	self.perkIcon[1] thread destroyOnOvertime();
	self.perkIcon[2] thread destroyOnOvertime();

	for(i=0;i<3;i++){
		self.perkIcon[i] fadeOverTime( 2.00 );
		self.perkIcon[i].alpha = 1;
		self.perkIcon[i].archived = false;
	}
}

destroyOnOvertime(){
	level waittill_any("begin_overtime", "overtime_over", "game_ended", "showing_final_killcam", "game_cleanup");
	if ( isdefined( self ) )
		self destroy();
}

giveEquipment(){
	self setlethalweapon(level.loudout["equipment"]["grenade"]);
	self maps\mp\gametypes\_class::giveoffhand(level.loudout["equipment"]["grenade"]);
	if(level.loudout["equipment"]["grenade"] == "h2_semtex_mp" && level.matchBeginTimer > 0 && level.loudout["equipment"]["class"] == "impact")
		self thread notifyImpactIcon();

	if(level.loudout["special"]["grenade"] == "specialty_tacticalinsertion")
		self thread giveStims();
	else{
		self settacticalweapon( level.loudout["special"]["grenade"] );
		self maps\mp\gametypes\_class::giveoffhand(level.loudout["special"]["grenade"]);
	}

	while(!level.takeEquipment)
		wait 0.1;
	if(level.loudout["equipment"]["grenade"] != "iw9_throwknife_mp")
		self takeWeapon(level.loudout["equipment"]["grenade"]);
	self takeWeapon(level.loudout["special"]["grenade"]);
	while(level.equipmentTimer > 0 && !level.devMode){
		if((self FragButtonPressed() && level.loudout["equipment"]["grenade"] != "iw9_throwknife_mp") || self SecondaryOffhandButtonPressed()){
			self iPrintLnBold("Equipment is unavailable for " + level.equipmentTimer + " seconds.");
			wait 0.8;
		}
		wait 0.025;
	}
	self playLocalSound("player_refill_all_ammo");
	if(level.loudout["equipment"]["grenade"] != "iw9_throwknife_mp"){
		self setlethalweapon( level.loudout["equipment"]["grenade"] );
		self maps\mp\gametypes\_class::giveoffhand(level.loudout["equipment"]["grenade"]);
	}
	if(level.loudout["special"]["grenade"] != "specialty_tacticalinsertion"){
		self settacticalweapon( level.loudout["special"]["grenade"] );
		self maps\mp\gametypes\_class::giveoffhand(level.loudout["special"]["grenade"]);
	}
}

checkEndGame(){
    self waittill("death");
	level waittill("updated_player_count");
    if(level.matchBeginTimer <= 0 && game["state"] == "playing" && (level.manualAliveCount["allies"] == 0 || level.manualAliveCount["axis"] == 0)){
        self maps\mp\gametypes\common_sd_sr::sd_endgame(undefined, undefined, true);
    }
}

forceHealth(){
	while(isAlive(self)){
		if(self.health > self.oldhealth && !self.usedStim){
			self.health = self.oldhealth;
			self.maxhealth = self.health;
		}
		else if (self.usedStim){
			self.usedStim = 0;
			if(!self.theOne){
				self.health = getDvarInt("gf_maxhealth");
				self.maxhealth = getDvarInt("gf_maxhealth");
			}
			else{
				newhealth = self.health+100;
				if(newhealth > (getDvarInt("gf_maxhealth")*2))
					newhealth = (getDvarInt("gf_maxhealth")*2);
				self.health = newhealth;
				self.maxhealth = (getDvarInt("gf_maxhealth")*2);
			}
		}
		self.oldhealth = self.health;
		wait 0.1;
	}
}

monitorHealth(){
	level endon("disconnect");
	oldMaxHealthAllies = 0;
	oldMaxHealthAxis = 0;
	while(game["state"] != "postgame"){
		if(level.sharedHealth == "none"){
			if((getDvarInt("gf_maxhealth") * level.AlliesPlaying) != oldMaxHealthAllies){
				level.AlliesMaxHealth = (getDvarInt("gf_maxhealth") * level.AlliesPlaying);
				oldMaxHealthAllies = (getDvarInt("gf_maxhealth") * level.AlliesPlaying);
			}
			if((getDvarInt("gf_maxhealth") * level.AxisPlaying) != oldMaxHealthAxis){
				level.AxisMaxHealth = (getDvarInt("gf_maxhealth") * level.AxisPlaying);
				oldMaxHealthAxis = (getDvarInt("gf_maxhealth") * level.AxisPlaying);
			}
		}
		else if(level.sharedHealth == "allies"){
			if((getDvarInt("gf_maxhealth") * 2) != oldMaxHealthAllies){
				level.AlliesMaxHealth = (getDvarInt("gf_maxhealth") * 2);
				oldMaxHealthAllies = (getDvarInt("gf_maxhealth") * 2);
			}
			if((getDvarInt("gf_maxhealth") * level.AxisPlaying) != oldMaxHealthAxis){
				level.AxisMaxHealth = (getDvarInt("gf_maxhealth") * level.AxisPlaying);
				oldMaxHealthAxis = (getDvarInt("gf_maxhealth") * level.AxisPlaying);
			}
		}
		else if(level.sharedHealth == "axis"){
			if((getDvarInt("gf_maxhealth") * level.AlliesPlaying) != oldMaxHealthAllies){
				level.AlliesMaxHealth = (getDvarInt("gf_maxhealth") * level.AlliesPlaying);
				oldMaxHealthAllies = (getDvarInt("gf_maxhealth") * level.AlliesPlaying);
			}
			if((getDvarInt("gf_maxhealth") * 2) != oldMaxHealthAxis){
				level.AxisMaxHealth = (getDvarInt("gf_maxhealth") * 2);
				oldMaxHealthAxis = (getDvarInt("gf_maxhealth") * 2);
			}
		}
		level.AxisHealth = 0;
		level.AlliesHealth = 0;
		foreach(player in level.players){
			if(player.team == "allies" && player.health >= 0 && player.sessionstate == "playing")
				level.AlliesHealth += player.health;
			if(player.team == "axis" && player.health >= 0 && player.sessionstate == "playing")
				level.AxisHealth += player.health;
			if(level.AlliesPlaying < level.manualAliveCount["allies"] || level.AxisPlaying < level.manualAliveCount["axis"]){
				level.AlliesPlaying = level.manualAliveCount["allies"];
				level.AxisPlaying = level.manualAliveCount["axis"];
			}
		}
		wait 0.025;
	}
	if(level.AlliesHealth < 0)
		level.AlliesHealth = 0;
	if(level.AxisHealth < 0)
		level.AxisHealth = 0;
}

debugButtonsMode(){
    self endon("death");
	self.sounddd=0;
	while(!level.mapBuilt)
		wait 0.1;
    for(;;){
		if(getDvarInt("dev_mode") == 1){
			if ( self usebuttonpressed() ){
				if(isDefined(level.flagTestSpawnPos))
					self thread spawnFlag(level.flagTestSpawnPos);
				//self thread startExfilHeli();
				//if(isDefined(level.flagSpawnPos))
				//	self thread spawnFlag(level.flagSpawnPos);
				//self thread testClone();
				/*if(self getStance() == "prone"){
					foreach(player in level.players)
					{
						if(player.team != self.team)
							player setOrigin(self.origin);
					}
				}*/
				//logprint("\n###################################\n New Gun: "+self getCurrentWeapon()+ "\n###################################\n");
				//self iPrintLnBold(level.testing22);
				//self iPrintLn("test");
			}
			if ( self fragbuttonpressed()){
				//self thread forceBotTeam();
				//self.costume = randomcostume();
				self.gameInfo.x++;
				//self setplayerdata( common_scripts\utility::getstatsgroup_common(), "globalCostume", var_0, var_1 );
				//self setcostumemodels(self.costume);
			}
			if ( self fragbuttonpressed() 
			//&& self getStance() == "prone"
			){
				level.loudout["weapons"]["primary"] = "";
				level.loudout["weapons"]["secondary"] = "";
				level.loudout["equipment"]["grenade"] = "";
				level getRandomPerks();
				//level getRandomSpecial();
				//level getRandomEquipment();
				level pickRandomWeapons();
				foreach(player in level.players){
					player thread setupPlayer(false, false);
				}
				//self iPrintLn(level.loudout["weapons"]["primary"]);
				//wait 0.1;
				//iPrintLnBold(level.loudout["weapons"]["primary"]);
				//iPrintLn("allies "+level.manualAliveCount["allies"]);
				//iPrintLn("axis "+level.manualAliveCount["axis"]);
			}
			if ( self attackButtonPressed() ){
				//self playlocalsound( level.warn_capturing );
				logprint("\n\n"+self getCurrentWeapon()+"\n\n");
			}
		}
        wait 0.025;
    }
}

forceBotTeam(){
	foreach(player in level.players){
		if(isBot(player)){
			player maps\mp\gametypes\_menus::addToTeam( "axis" );
			player _suicide();
		}
		else{
			player maps\mp\gametypes\_menus::addToTeam( "allies" );
			player _suicide();
		}
	}
}

tUFO()
{
	self endon("disconnect");
	self endon("death");
	//self.UFOnew = 0;
	self notifyOnPlayerCommand("melee","+melee_zoom");
	self thread newufonew();
	//self iPrintlnBold("^3Crouch And [{+melee}] To Enable UFO");
	for(;;)
	{
	self waittill("melee");
	if(self GetStance()== "crouch" && getDvarInt("dev_mode") == 1)
		{
			self thread tUFO2();
		}
		wait 0.01;
	}
}

tUFO2()
{
	if(!self.IsUFO)
	{
		self.IsUFO=true;
		self iPrintlnBold("UFO Mode: ^5On");
		self.owp=self getWeaponsListOffhands();
		foreach(w in self.owp)self takeweapon(w);
		self.newufo.origin=self.origin;
		self playerlinkto(self.newufo);
	}
	else
	{
		self iPrintlnBold("UFO Mode: ^5Off");
		self.IsUFO=false;
		self unlink();
		foreach(w in self.owp)
			self giveweapon(w);
	}
	wait 0.001;
}
Newufonew()
{
	if(isdefined(self.newufo))
		self.newufo delete();	
	self.newufo=spawn("script_origin",self.origin);
	self thread NewUFO();
}
NewUFO()
{
	self endon("disconnect");
	self endon("death");
	for(;;)
	{
		if(self.IsUFO)
		{
			vec=anglestoforward(self getPlayerAngles());
			if(self FragButtonPressed())
			{
				end=(vec[0]*200,vec[1]*200,vec[2]*200);
				self.newufo.origin=self.newufo.origin+end;
			}
			else if(self SecondaryOffhandButtonPressed())
			{
				end=(vec[0]*5,vec[1]*5,vec[2]*5);
				self.newufo.origin=self.newufo.origin+end;
			}
		}
		wait 0.05;
	}
}

gf_endgame(var_0, var_1, var_2){
	if ( !isdefined( var_2 ) )
        var_2 = 0;

    game["state"] = "postgame";
    setdvar( "ui_game_state", "postgame" );
    level.gameendtime = gettime();
    level.gameended = 1;
    level.ingraceperiod = 0;
    level notify( "game_ended", var_0 );
    maps\mp\_utility::levelflagset( "game_over" );
    maps\mp\_utility::levelflagset( "block_notifies" );
    var_3 = maps\mp\gametypes\_gamelogic::getgameduration();
    setomnvar( "ui_game_duration", var_3 * 1000 );
    maps\mp\_utility::setgameplayactive( 0 );
    waitframe();
    setgameendtime( 0 );
    setmatchdata( "gameLengthSeconds", var_3 );
    setmatchdata( "endTimeUTC", getsystemtime() );
    maps\mp\gametypes\_gamelogic::checkgameendchallenges();

    if ( isdefined( var_0 ) && isstring( var_0 ) && maps\mp\_utility::isovertimetext( var_0 ) )
    {
        level.finalkillcam_winner = "none";
        level.finalkillcam_timegameended[level.finalkillcam_winner] = maps\mp\_utility::getsecondspassed();
        maps\mp\gametypes\_gamelogic::endgameovertime( var_0, var_1 );
        return;
    }

    if ( isdefined( var_0 ) && isstring( var_0 ) && var_0 == "halftime" )
    {
        level.finalkillcam_winner = "none";
        level.finalkillcam_timegameended[level.finalkillcam_winner] = maps\mp\_utility::getsecondspassed();
        maps\mp\gametypes\_gamelogic::endgamehalftime( var_1 );
        return;
    }

    if ( isdefined( level.finalkillcam_winner ) )
        level.finalkillcam_timegameended[level.finalkillcam_winner] = maps\mp\_utility::getsecondspassed();

    game["roundsPlayed"]++;

    if ( level.gametype != "ctf" )
        setomnvar( "ui_current_round", game["roundsPlayed"] );

    if ( level.teambased )
    {
        if ( ( var_0 == "axis" || var_0 == "allies" ) && level.gametype != "ctf" )
            game["roundsWon"][var_0]++;

        maps\mp\gametypes\_gamescore::updateteamscore( "axis" );
        maps\mp\gametypes\_gamescore::updateteamscore( "allies" );
    }
    else if ( isdefined( var_0 ) && isplayer( var_0 ) )
        game["roundsWon"][var_0.guid]++;

    maps\mp\gametypes\_gamescore::updateplacement();
    maps\mp\gametypes\_gamelogic::rankedmatchupdates( var_0 );
    maps\mp\gametypes\_gamelogic::handlekillstreaksonroundswitch( 1 );

    foreach ( var_5 in level.players )
        var_5 setclientdvar( "ui_opensummary", 1 );

    setdvar( "g_deadChat", 1 );
    setdvar( "ui_allow_teamchange", 0 );
    setdvar( "bg_compassShowEnemies", 0 );
    //freezeallplayers( 1.0, 1 );
    var_7 = game["switchedsides"];

    if ( !maps\mp\_utility::wasonlyround() && !var_2 )
    {
        maps\mp\gametypes\_gamelogic::displayroundend( var_0, var_1 );

        if ( isdefined( level.finalkillcam_winner ) )
        {
            foreach ( var_5 in level.players )
                var_5 notify( "reset_outcome" );

            level notify( "game_cleanup" );
            maps\mp\gametypes\_gamelogic::waittillfinalkillcamdone();
        }

        if ( !maps\mp\_utility::waslastround() )
        {
            maps\mp\_utility::levelflagclear( "block_notifies" );

            if ( maps\mp\gametypes\_gamelogic::checkroundswitch() )
                maps\mp\gametypes\_gamelogic::displayroundswitch( var_7 );

            foreach ( var_5 in level.players )
            {
                var_5.pers["stats"] = var_5.stats;
                var_5.pers["segments"] = var_5.segments;
            }

            level notify( "restarting" );
            game["state"] = "playing";
            setdvar( "ui_game_state", "playing" );
			wait 1;
            map_restart( 1 );
            return;
        }

        if ( !level.forcedend )
            var_1 = maps\mp\gametypes\_gamelogic::updateendreasontext( var_0 );
    }

    if ( !isdefined( game["clientMatchDataDef"] ) )
    {
        game["clientMatchDataDef"] = "mp/clientmatchdata.ddl";
        setclientmatchdatadef( game["clientMatchDataDef"] );
    }

    maps\mp\gametypes\_missions::roundend( var_0 );
    var_0 = maps\mp\gametypes\_gamelogic::getgamewinner( var_0, 1 );

    if ( level.teambased )
    {
        setomnvar( "ui_game_victor", 0 );

        if ( var_0 == "allies" )
            setomnvar( "ui_game_victor", 2 );
        else if ( var_0 == "axis" )
            setomnvar( "ui_game_victor", 1 );
    }

    maps\mp\gametypes\_gamelogic::displaygameend( var_0, var_1 );
    var_12 = gettime();

    if ( isdefined( level.finalkillcam_winner ) && maps\mp\_utility::wasonlyround() )
    {
        foreach ( var_5 in level.players )
            var_5 notify( "reset_outcome" );

        level notify( "game_cleanup" );
        maps\mp\gametypes\_gamelogic::waittillfinalkillcamdone();
    }

    maps\mp\_utility::levelflagclear( "block_notifies" );
    level.intermission = 1;
    level notify( "spawning_intermission" );

    foreach ( var_5 in level.players )
    {
        var_5 closepopupmenu();
        var_5 closeingamemenu();
        var_5 notify( "reset_outcome" );
        var_5 setclientomnvar( "ui_toggle_final_scoreboard", 1 );
        var_5 thread maps\mp\gametypes\_playerlogic::spawnintermission();
    }

    maps\mp\gametypes\_gamelogic::processlobbydata();
    maps\mp\_skill::process();
    wait 1.0;
    maps\mp\gametypes\_gamelogic::checkforpersonalbests();
    maps\mp\gametypes\_gamelogic::updatecombatrecord();

    if ( level.teambased )
    {
        if ( var_0 == "axis" || var_0 == "allies" )
            setmatchdata( "victor", var_0 );
        else
            setmatchdata( "victor", "none" );

        setmatchdata( "alliesScore", game["teamScores"]["allies"] );
        setmatchdata( "axisScore", game["teamScores"]["axis"] );
        tournamentreportwinningteam( var_0 );
    }
    else
        setmatchdata( "victor", "none" );

    level maps\mp\_matchdata::endofgamesummarylogger();

    foreach ( var_5 in level.players )
    {
        if ( var_5 maps\mp\_utility::rankingenabled() )
            var_5 maps\mp\_matchdata::logfinalstats();

        var_5 maps\mp\gametypes\_playerlogic::logplayerstats();
    }

    setmatchdata( "host", maps\mp\gametypes\_playerlogic::truncateplayername( level.hostname ) );

    if ( maps\mp\_utility::matchmakinggame() )
    {
        setmatchdata( "playlistVersion", getplaylistversion() );
        setmatchdata( "playlistID", getplaylistid() );
        setmatchdata( "isDedicated", isdedicatedserver() );
    }

    setmatchdata( "levelMaxClients", level.maxclients );
    sendmatchdata();
    var_19 = getmatchdata( "victor" );
    maps\mp\gametypes\_gamelogic::recordendgamecomscoreevent( var_19 );

    foreach ( var_5 in level.players )
    {
        var_5.pers["stats"] = var_5.stats;
        var_5.pers["segments"] = var_5.segments;
    }

    tournamentreportendofgame();
    var_22 = 0;

    if ( isdefined( level.endgamewaitfunc ) )
        [[ level.endgamewaitfunc ]]( var_2, level.postgamenotifies, var_22, var_0 );
    else if ( !var_2 && !level.postgamenotifies )
    {
        if ( !maps\mp\_utility::wasonlyround() )
            wait(6.0 + var_22);
        else
            wait(min( 10.0, 4.0 + var_22 + level.postgamenotifies ));
    }
    else
        wait(min( 10.0, 4.0 + var_22 + level.postgamenotifies ));

    var_23 = "_gamelogic.gsc";
    var_24 = "all";

    if ( level.teambased && isdefined( var_0 ) )
        var_24 = var_0;

    var_25 = "undefined";

    if ( isdefined( var_1 ) )
    {
        switch ( var_1 )
        {
            case 1:
                var_25 = "MP_SCORE_LIMIT_REACHED";
                break;
            case 2:
                var_25 = "MP_TIME_LIMIT_REACHED";
                break;
            case 3:
                var_25 = "MP_PLAYERS_FORFEITED";
                break;
            case 4:
                var_25 = "MP_TARGET_DESTROYED";
                break;
            case 5:
                var_25 = "MP_BOMB_DEFUSED";
                break;
            case 6:
                var_25 = "MP_SAS_ELIMINATED";
                break;
            case 7:
                var_25 = "MP_SPETSNAZ_ELIMINATED";
                break;
            case 8:
                var_25 = "MP_SAS_FORFEITED";
                break;
            case 9:
                var_25 = "MP_SPETSNAZ_FORFEITED";
                break;
            case 10:
                var_25 = "MP_SAS_MISSION_ACCOMPLISHED";
                break;
            case 11:
                var_25 = "MP_SPETSNAZ_MISSION_ACCOMPLISHED";
                break;
            case 12:
                var_25 = "MP_ENEMIES_ELIMINATED";
                break;
            case 13:
                var_25 = "MP_MATCH_TIE";
                break;
            case 14:
                var_25 = "GAME_OBJECTIVECOMPLETED";
                break;
            case 15:
                var_25 = "GAME_OBJECTIVEFAILED";
                break;
            case 16:
                var_25 = "MP_SWITCHING_SIDES";
                break;
            case 17:
                var_25 = "MP_ROUND_LIMIT_REACHED";
                break;
            case 18:
                var_25 = "MP_ENDED_GAME";
                break;
            case 19:
                var_25 = "MP_HOST_ENDED_GAME";
                break;
            case 20:
                var_25 = "MP_PREVENT_STAT_LOSS";
                break;
            default:
                break;
        }
    }

    if ( !isdefined( var_12 ) )
        var_12 = -1;

    var_26 = 15;
    var_27 = var_26;
    var_28 = getmatchdata( "playerCount" );
    var_29 = getmatchdata( "lifeCount" );

    if ( !isdefined( level.matchdata ) )
    {
        var_30 = 0;
        var_31 = 0;
        var_32 = 0;
        var_33 = 0;
        var_34 = 0;
        var_35 = 0;
        var_36 = 0;
    }
    else
    {
        if ( isdefined( level.matchdata["botJoinCount"] ) )
            var_30 = level.matchdata["botJoinCount"];
        else
            var_30 = 0;

        if ( isdefined( level.matchdata["deathCount"] ) )
            var_31 = level.matchdata["deathCount"];
        else
            var_31 = 0;

        if ( isdefined( level.matchdata["badSpawnDiedTooFastCount"] ) )
            var_32 = level.matchdata["badSpawnDiedTooFastCount"];
        else
            var_32 = 0;

        if ( isdefined( level.matchdata["badSpawnKilledTooFastCount"] ) )
            var_33 = level.matchdata["badSpawnKilledTooFastCount"];
        else
            var_33 = 0;

        if ( isdefined( level.matchdata["badSpawnDmgDealtCount"] ) )
            var_34 = level.matchdata["badSpawnDmgDealtCount"];
        else
            var_34 = 0;

        if ( isdefined( level.matchdata["badSpawnDmgReceivedCount"] ) )
            var_35 = level.matchdata["badSpawnDmgReceivedCount"];
        else
            var_35 = 0;

        if ( isdefined( level.matchdata["badSpawnByAnyMeansCount"] ) )
            var_36 = level.matchdata["badSpawnByAnyMeansCount"];
        else
            var_36 = 0;
    }

    var_37 = 0;
    reconevent( "script_mp_match_end: script_file %s, gameTime %d, match_winner %s, win_reason %s, version %d, joinCount %d, botJoinCount %d, spawnCount %d, deathCount %d, badSpawnDiedTooFastCount %d, badSpawnKilledTooFastCount %d, badSpawnDmgDealtCount %d, badSpawnDmgReceivedCount %d, badSpawnByAnyMeansCount %d, sightTraceMethodsUsed %d", var_23, var_12, var_24, var_25, var_27, var_28, var_30, var_29, var_31, var_32, var_33, var_34, var_35, var_36, var_37 );

    if ( isdefined( level.ishorde ) && level.ishorde )
    {
        if ( isdefined( level.zombiescompleted ) && level.zombiescompleted )
            setdvar( "cg_drawCrosshair", 1 );
    }

    level notify( "exitLevel_called" );
    exitlevel( 0 );
}